/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.mib;

import ibm.nways.jdm.mib.MibImport;
import ibm.nways.jdm.mib.MibMetadata;
import ibm.nways.jdm.mib.MibObject;
import ibm.nways.jdm.mib.MibObjectIdentifierValue;
import ibm.nways.jdm.mib.MibSequence;
import ibm.nways.jdm.mib.MibSequenceOf;
import ibm.nways.jdm.mib.MibTrap;
import ibm.nways.jdm.mib.MibType;
import ibm.nways.jdm.mib.MibValue;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MibModule {
    protected MibMetadata metadata;
    private Hashtable types = new Hashtable();
    private Hashtable values = new Hashtable();
    private Hashtable objects = new Hashtable();
    private Hashtable traps = new Hashtable();
    private static final boolean traceimports = false;
    protected Hashtable imports = new Hashtable();
    public String id;
    public String name;

    protected MibModule(MibMetadata mibMetadata) {
        this.metadata = mibMetadata;
        this.values.put("ccitt", new MibObjectIdentifierValue(this, "ccitt", "0"));
        this.values.put("iso", new MibObjectIdentifierValue(this, "iso", "1"));
        this.values.put("joint-iso-ccitt", new MibObjectIdentifierValue(this, "joint-iso-ccitt", "2"));
        this.values.put("org", new MibObjectIdentifierValue(this, "org", "1.3"));
        this.values.put("dod", new MibObjectIdentifierValue(this, "dod", "1.3.6"));
        this.values.put("internet", new MibObjectIdentifierValue(this, "internet", "1.3.6.1"));
        this.values.put("directory", new MibObjectIdentifierValue(this, "directory", "1.3.6.1.1"));
        this.values.put("mgmt", new MibObjectIdentifierValue(this, "mgmt", "1.3.6.1.2"));
        this.values.put("experimental", new MibObjectIdentifierValue(this, "experimental", "1.3.6.1.3"));
        this.values.put("private", new MibObjectIdentifierValue(this, "private", "1.3.6.1.4"));
        this.values.put("enterprises", new MibObjectIdentifierValue(this, "enterprises", "1.3.6.1.4.1"));
        this.values.put("mib-2", new MibObjectIdentifierValue(this, "mib-2", "1.3.6.1.2.1"));
        this.values.put("security", new MibObjectIdentifierValue(this, "security", "1.3.6.1.5"));
        this.values.put("snmpV2", new MibObjectIdentifierValue(this, "snmpv2", "1.3.6.1.6"));
        this.values.put("snmpDomains", new MibObjectIdentifierValue(this, "snmpDomains", "1.3.6.1.6.1"));
        this.values.put("snmpProxys", new MibObjectIdentifierValue(this, "snmpProxys", "1.3.6.1.6.2"));
        this.values.put("snmpModules", new MibObjectIdentifierValue(this, "snmpModules", "1.3.6.1.6.3"));
    }

    public boolean resolveReferences() {
        return true;
    }

    protected void putValue(String string, MibValue mibValue) {
        this.values.put(string, mibValue);
    }

    public boolean containsValue(String string) {
        if (string == null) {
            return false;
        }
        return this.values.containsKey(string);
    }

    public MibValue getValue(String string) {
        if (string == null) {
            return null;
        }
        return (MibValue)this.values.get(string);
    }

    public Enumeration getValues() {
        return this.values.keys();
    }

    public void dumpValues(PrintStream printStream) {
        printStream.println("Values defined in module " + this.name + " (" + this.values.size() + "):");
        Enumeration enumeration = this.values.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            MibObjectIdentifierValue mibObjectIdentifierValue = (MibObjectIdentifierValue)this.values.get(string);
            printStream.println(String.valueOf(mibObjectIdentifierValue) + ":" + string);
        }
    }

    protected void putType(String string, MibType mibType) {
        this.types.put(string, mibType);
    }

    public boolean containsType(String string) {
        if (string == null) {
            return false;
        }
        return this.types.containsKey(string);
    }

    public MibType getType(String string) {
        if (string == null) {
            return null;
        }
        return (MibType)this.types.get(string);
    }

    public Enumeration getTypes() {
        return this.types.keys();
    }

    public void dumpTypes(PrintStream printStream) {
        printStream.println("Types defined in module " + this.name + " (" + this.types.size() + "):");
        Enumeration enumeration = this.types.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            MibType mibType = (MibType)this.types.get(string);
            printStream.println("   " + string + ":" + mibType.toString());
        }
    }

    protected void putTrap(String string, MibTrap mibTrap) {
        this.traps.put(string, mibTrap);
    }

    public boolean containsTrap(String string) {
        if (string == null) {
            return false;
        }
        return this.traps.containsKey(string);
    }

    public MibTrap getTrap(String string) {
        if (string == null) {
            return null;
        }
        return (MibTrap)this.traps.get(string);
    }

    public Enumeration getTraps() {
        return this.traps.keys();
    }

    protected void dumpTraps(PrintStream printStream) {
        printStream.println("Traps defined in module " + this.name + " (" + this.traps.size() + "):");
        Enumeration enumeration = this.traps.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            MibTrap mibTrap = (MibTrap)this.traps.get(string);
            printStream.println(mibTrap.toString());
        }
    }

    protected void putObject(String string, MibObject mibObject) {
        this.objects.put(string, mibObject);
    }

    public boolean containsObject(String string) {
        return this.objects.containsKey(string);
    }

    public MibObject getObject(String string) {
        return (MibObject)this.objects.get(string);
    }

    public Enumeration getObjects() {
        return this.objects.keys();
    }

    public void dumpObjects(PrintStream printStream) {
        printStream.println("Objects defined in module " + this.name + " (" + this.objects.size() + "):");
        Enumeration enumeration = this.objects.elements();
        while (enumeration.hasMoreElements()) {
            MibObject mibObject = (MibObject)enumeration.nextElement();
            printStream.println("   " + mibObject.toString());
        }
    }

    public void dumpObjType(PrintStream printStream) {
        Enumeration enumeration = this.objects.elements();
        while (enumeration.hasMoreElements()) {
            MibObject mibObject = (MibObject)enumeration.nextElement();
            StringBuffer stringBuffer = new StringBuffer(mibObject.name);
            stringBuffer.append(" ");
            stringBuffer.append(mibObject.id.toString());
            stringBuffer.append(" ");
            if (mibObject.type != null) {
                stringBuffer.append(mibObject.type.toString());
            } else {
                stringBuffer.append("unknown");
            }
            printStream.println(stringBuffer.toString());
        }
    }

    public void dumpTables(PrintStream printStream) {
        printStream.println("Tables defined in module " + this.name + ":");
        Enumeration enumeration = this.objects.elements();
        while (enumeration.hasMoreElements()) {
            MibObject mibObject = (MibObject)enumeration.nextElement();
            if (mibObject.indexList == null) continue;
            printStream.println("   " + mibObject.name);
            int n = 0;
            while (n < mibObject.indexList.size()) {
                String string = (String)mibObject.indexList.elementAt(n);
                Boolean bl = (Boolean)mibObject.impliedList.elementAt(n);
                if (bl.booleanValue()) {
                    printStream.println("      " + string + " IMPLIED");
                } else {
                    printStream.println("      " + string);
                }
                ++n;
            }
        }
    }

    public void genSummary(Hashtable hashtable) {
        Object object;
        Serializable serializable;
        Object object2;
        System.err.println("Generating summary for module: " + this.name);
        Enumeration enumeration = this.values.keys();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            serializable = (MibObjectIdentifierValue)this.values.get(object2);
            object = ((MibObjectIdentifierValue)serializable).toString();
            if (hashtable.containsKey(object)) continue;
            if (((String)object).startsWith("1")) {
                hashtable.put(object, "1:" + (String)object + ":" + (String)object2 + ":");
                continue;
            }
            if (((String)object).equals("0") || ((String)object).equals("1") || ((String)object).equals("2")) continue;
            System.err.println("Warning: OBJECT IDENTIFIER " + (String)object + " not placed in summary file");
            System.err.println("         It is a current limitation of the MIB Browser that only OIs");
            System.err.println("         starting with a one are supported.");
        }
        object2 = this.objects.elements();
        while (object2.hasMoreElements()) {
            serializable = new StringBuffer("2:");
            object = (MibObject)object2.nextElement();
            ((StringBuffer)serializable).append(((MibObject)object).id).append(":");
            ((StringBuffer)serializable).append(((MibObject)object).name).append(":");
            ((StringBuffer)serializable).append(((MibObject)object).access).append(":");
            ((StringBuffer)serializable).append(((MibObject)object).isInTable()).append(":");
            ((StringBuffer)serializable).append(((MibObject)object).type.getTypeEnum()).append(":");
            ((StringBuffer)serializable).append(((MibObject)object).getFixedLength()).append(":");
            if (((MibObject)object).indexList != null) {
                int n = 0;
                while (n < ((MibObject)object).indexList.size()) {
                    MibObject mibObject;
                    if (n > 0) {
                        ((StringBuffer)serializable).append(",");
                    }
                    if ((mibObject = this.metadata.getObject((String)((MibObject)object).indexList.elementAt(n))) != null) {
                        ((StringBuffer)serializable).append(mibObject.id.toString());
                    } else {
                        ((StringBuffer)serializable).append("unknown");
                        System.err.println("Error: Unable to locate index" + ((MibObject)object).indexList.elementAt(n) + " for object " + ((MibObject)object).name);
                    }
                    Boolean bl = (Boolean)((MibObject)object).impliedList.elementAt(n);
                    if (bl.booleanValue()) {
                        ((StringBuffer)serializable).append("*");
                    }
                    ++n;
                }
            }
            ((StringBuffer)serializable).append(":");
            if (((MibObject)object).description != null) {
                ((StringBuffer)serializable).append(((MibObject)object).description.length()).append(":");
                ((StringBuffer)serializable).append(((MibObject)object).description).append(":");
            } else {
                ((StringBuffer)serializable).append("0::");
            }
            hashtable.put(((MibObject)object).id.toString(), ((StringBuffer)serializable).toString());
        }
    }

    public MibType getActualObjectType(String string) {
        MibObject mibObject = (MibObject)this.objects.get(string);
        return mibObject.type.getActualType();
    }

    protected void putImport(String string, MibImport mibImport) {
        this.imports.put(string, mibImport);
    }

    public MibImport getImport(String string) {
        return (MibImport)this.imports.get(string);
    }

    public void dumpImports(PrintStream printStream) {
        printStream.println("Imports defined in module " + this.name + " (" + this.imports.size() + "):");
        Enumeration enumeration = this.imports.elements();
        while (enumeration.hasMoreElements()) {
            MibImport mibImport = (MibImport)enumeration.nextElement();
            printStream.println("   " + mibImport.toString());
        }
    }

    protected void postprocess() {
        Serializable serializable;
        Object object;
        Object object2;
        Enumeration enumeration;
        Serializable serializable2;
        Serializable serializable3;
        Serializable serializable4;
        Object object3;
        Object object4;
        Enumeration enumeration2 = this.objects.elements();
        while (enumeration2.hasMoreElements()) {
            object4 = (MibObject)enumeration2.nextElement();
            object3 = ((MibObject)object4).type.getActualType();
            if (!(object3 instanceof MibSequenceOf) || !((serializable4 = ((MibSequenceOf)(serializable3 = (MibSequenceOf)object3)).getComponentType().getActualType()) instanceof MibSequence)) continue;
            serializable2 = (MibSequence)serializable4;
            enumeration = serializable2.getComponents();
            while (enumeration.hasMoreElements()) {
                object2 = (String)enumeration.nextElement();
                object = (MibType)serializable2.components.get(object2);
                serializable = this.getObject(((MibType)object).name);
                if (serializable != null) {
                    ((MibObject)serializable).type.markInTable();
                    continue;
                }
                System.err.println("Error: Table member not defined as a object!");
                System.err.println("       Unable to locate object corresponding to " + ((MibType)object).name);
            }
        }
        object4 = this.values.elements();
        while (object4.hasMoreElements()) {
            object3 = (MibValue)object4.nextElement();
            if (!(object3 instanceof MibObjectIdentifierValue)) continue;
            serializable3 = (MibObjectIdentifierValue)object3;
            ((MibObjectIdentifierValue)serializable3).resolve();
        }
        object3 = this.values.elements();
        while (object3.hasMoreElements()) {
            serializable3 = (MibValue)object3.nextElement();
            if (!(serializable3 instanceof MibObjectIdentifierValue) || !((MibObjectIdentifierValue)(serializable4 = (MibObjectIdentifierValue)serializable3)).isResolved()) continue;
            this.metadata.insertOINode((MibObjectIdentifierValue)serializable4);
        }
        serializable3 = null;
        enumeration = this.traps.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (MibTrap)enumeration.nextElement();
            serializable = this.getValue(((MibTrap)object2).getEnterpriseName());
            if (serializable instanceof MibObjectIdentifierValue) {
                serializable3 = (MibObjectIdentifierValue)serializable;
                ((MibTrap)object2).setEnterpriseOid(((MibObjectIdentifierValue)serializable3).getValue());
            }
            object = ((MibTrap)object2).getVariableList().elements();
            Vector<MibType> vector = new Vector<MibType>();
            while (object.hasMoreElements()) {
                serializable4 = object.nextElement();
                if (!(serializable4 instanceof String)) continue;
                serializable2 = this.getObject((String)((Object)serializable4));
                if (serializable2 != null) {
                    vector.addElement((MibType)serializable2);
                    continue;
                }
                vector.addElement((MibType)serializable4);
            }
            ((MibTrap)object2).setVariableList(vector);
        }
    }
}

